Dim sDefaultSource : sDefaultSource = ""
Dim sDefaultDest : sDefaultDest = "special.prn"
Dim sDefaultDestPrinter : sDefaultDestPrinter = "A:\\script\\printer.lua"
Dim sRestartDefault : sRestartDefault = "yes"

Dim sSource
Dim sDest : sDest = sDefaultDest
Dim sDestPrinter : sDestPrinter = sDefaultDestPrinter
Dim sRestart : sRestart = sRestartDefault

Dim strMsgMain

Dim sTitle :sTitle = "HeaderMaker GUI"

Dim wshShell, fso, tempDir, tempFileName, fTemp
Const fsoForReading = 1, fsoForWriting = 2

Sub GetTempFileContent()
    Dim f
    Set f = fso.GetFile(tempFileName)
    If f.Size > 0 then
        Set f = fso.OpenTextFile(tempFileName, fsoForReading)
        sSource = f.ReadLine
        sDest = f.ReadLine
        sDestPrinter = f.ReadLine
        if Not (f.AtEndOfStream) then
            sRestart = f.ReadLine
        End If
        f.Close
    Else
        sSource = sDefaultSource
        sDest = sDefaultDest
        sDestPrinter = sDefaultDestPrinter
        sRestart = sDefaultDestPrinter
    End If    
End Sub

Sub SaveTempFileContent()
    Dim f
    Set f = fso.OpenTextFile(tempFileName, fsoForWriting)
    f.WriteLine sSource
    f.WriteLine sDest
    f.WriteLine sDestPrinter
    f.WriteLine sRestart
    f.Close
End Sub

Function GetFileName(filter)
' filter format "desc|*.end"
    Dim objDialog
    Set objDialog = CreateObject("UserAccounts.CommonDialog")

    objDialog.InitialDir = CreateObject("WScript.Shell").SpecialFolders("MyDocuments")

    If filter = "" Then
        objDialog.Filter = "All files|*.*"
    Else
        objDialog.Filter = filter
    End If

    If objDialog.ShowOpen Then
        GetFileName = objDialog.FileName
    Else
        GetFileName = ""
    End If
End Function

Sub MenuDest
	Dim strMsg, inploop, inp
	strMsg = "Destination" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sDest = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub

Sub MenuDestPrinter
	Dim strMsg, inploop, inp
	strMsg = "Destination on printer" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sDestPrinter = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub

Sub MenuMainStrMsg()
    If Len(sSource) > 45 then
        strMsgMain =           "1. Source file: " & vbCR
        strMsgMain = strMsgMain & Mid(sSource,1,45) & vbCR
        strMsgMain = strMsgMain & Mid(sSource,46,Len(sSource)) & vbCR
    Else
        strMsgMain =           "1. Source file: " & sSource & vbCR
    End If
    strMsgMain = strMsgMain & "2. Destination file: " & sDest & vbCR
    strMsgMain = strMsgMain & "3. Destination on printer: " & sDestPrinter & vbCr
    strMsgMain = strMsgMain & "4. Add Restart: " & sRestart & vbCr
    strMsgMain = strMsgMain & "5. Set to default values" & vbCR
    strMsgMain = strMsgMain & "6. Execute" & vbCR
End Sub

Function MenuMain()
    Dim inp, inploop, inp2
    MenuMainStrMsg()
    inploop = True
    Do While inploop
        inp = InputBox(strMsgMain, sTitle)
        Select Case inp
            Case ""
                WScript.Quit(1)
            Case "1"
                Set oExec=wshShell.Exec("mshta.exe ""about:<input type=file id=FILE><script>FILE.click();new ActiveXObject('Scripting.FileSystemObject').GetStandardStream(1).WriteLine(FILE.value);close();resizeTo(0,0);</script>""")
                inp2 = oExec.StdOut.ReadLine                
                If Not Len(inp2) = 0 then
                    sSource = inp2
                    SaveTempFileContent()
                    MenuMainStrMsg()
                End If
            Case "2"
                MenuDest()
                MenuMainStrMsg()
            Case "3"
                MenuDestPrinter()
                MenuMainStrMsg()
            Case "4"
                If StrComp(sRestart, "yes") = 0 then
                    sRestart = "no"
                Else
                    sRestart = "yes"
                End If
                SaveTempFileContent()
                MenuMainStrMsg()
            Case "5"
                sDest = sDefaultDest
                sDestPrinter = sDefaultDestPrinter
                MenuMainStrMsg()
            Case "6"
                If Len(sSource) = 0 then
                    MsgBox "Incorrect input!" & vbCR & "Please choose a source file"
                Else
                    inploop = False
                    MenuMain = 5
                End If
            Case Else
                MsgBox "Incorrect input!" & vbCR & "Enter selection (i.e. '1')"
        End Select
    Loop
End Function

Set wshShell = CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")
tempDir = wshShell.ExpandEnvironmentStrings("%TEMP%")
tempFileName = tempDir & "\HdMakerGUI.ini"
If Not fso.FileExists(tempFileName) Then
    Set fTemp = fso.CreateTextFile(tempFileName, False)
    fTemp.close
End If

Set objShell = CreateObject("WScript.Shell")
Dim sRstCmd

GetTempFileContent

MenuMain()

If StrComp(sRestart, "yes") = 0 then
    sRstCmd = "/r"
Else
    sRstCmd = ""
End If

objShell.Run "cmd /C hdmaker " & sSource & " ..\\" & sDest & " " & sRstCmd & " /m=" & sDestPrinter & " & ping -n 4 localhost> nul" , 1, True
