#!/bin/bash

cd "$(dirname "$0")"

export TEMP=/tmp
export FIRMWARE=$(realpath ../../firmware.prn)
export DATA=$(realpath ../../data.prn)

RetCode=0
PrinterCheck4Idle=0

ITFSEND=./itfsend

Printer_Check4Idle() {
    ErrCode=0
    iRetVal=1
    
    START_T=$(date +%s)
    CHECK=1
    while [ $CHECK -eq 1 ]; do
	
	    printf "\x01U\x17" | $ITFSEND -d -s$IPADDR  -p9099 -rt2 -l -m0 -o$TEMP/itfsend.log
        ret=$?
        
        PRT_STATUS=$(cat $TEMP/itfsend.log)
        #echo "PrtStatus: $PRT_STATUS"
		
        PRT_STATUS=${PRT_STATUS:1:11}
		#echo "PrtStat: $PRT_STATUS"
        if [ -z "$PRT_STATUS" ]; then
            PRT_STATUS="Empty"
        fi
        if [ "$PRT_STATUS" = "1.0;BOOT-SW" ]; then
		    #echo "Failed"
            ErrCode=1
            echo "Try to connect, please wait ... or press ENTER to abort"
            read -t2
            iRetVal=$?
        else		
		    #echo "Not U-Boot! Try Status Req"
			printf "\x01SE\x17" | $ITFSEND -d -s$IPADDR -p9099 -rt2 -l -m0 -o$TEMP/itfsend.log
            ret=$?
            
            PRT_STATUS=$(cat $TEMP/itfsend.log)
            echo "PrtStatus: $PRT_STATUS"
            
			PRT_STATUS=${PRT_STATUS:1:5}
            echo "PrtStat: $PRT_STATUS"
            if [ -z "$PRT_STATUS" ]; then
                PRT_STATUS="Empty"
            fi
			if [ "$PRT_STATUS" = "#Idle" ] || [ "$PRT_STATUS" = "#Erro" ] || [ "$PRT_STATUS" = "#Stop" ]; then
				echo "Success"
				ErrCode=0
			else
				#echo "Failed"
				ErrCode=1
                echo "Try to connect, please wait ... or press ENTER to abort"
                read -t2
                iRetVal=$?
			fi			
        fi
		
        if [ $ErrCode -ne 0 ]; then
            END_T=$(date +%s)
            ERG=$(expr $END_T - $START_T)
            #echo "ERG: " $ERG
            #echo "ERG: " $TimeInSecs
            if [ $ERG -gt $TimeInSecs ]; then
                CHECK=0
            fi
        else
            CHECK=0
        fi
		if [ $iRetVal -eq 0 ]; then
			CHECK=0
		fi
    done
    
    if [ $ErrCode -eq 0 ]; then
        PrinterCheck4Idle=1
    else
        PrinterCheck4Idle=0
    fi
}

clear
echo Linux Printer Upload 1.0
echo
echo Update $FIRMWARE
echo
echo "1 - TCP-Port 9100 (<-Std)"

if [ -s $TEMP/CV_UL_Last_Itf.tmp ]
then
    LASTCHOICE=$(<$TEMP/CV_UL_Last_Itf.tmp)
    if (($LASTCHOICE == 1))
    then
        if [ -s $TEMP/CV_UL_Last_TCP.tmp ]
        then
            echo 2 - TCP-Port 9100: $(<$TEMP/CV_UL_Last_TCP.tmp)
            DEFAULT=1
        fi    
    fi
fi

if [ $DEFAULT ]
then
    CHOICE=$(./bi "? " 1 [12])
    if (($CHOICE != 2))
    then
        echo $CHOICE > $TEMP/CV_UL_Last_Itf.tmp
    fi
else
    CHOICE=$(./bi "? " [1])
    echo $CHOICE > $TEMP/CV_UL_Last_Itf.tmp
fi

clear

if (($CHOICE == 1))
then
    IPADDR=$(./bi "TCP IP? ")   
    
    $ITFSEND -d -r*9 -l -m1 -tx -s$IPADDR < "$FIRMWARE"
    Errcode=$?
    if [ $Errcode -ne 0 ] && [ $Errcode -ne 250 ]; then
        echo $Errcode
        read
        exit 1
    fi
    
    echo $IPADDR > $TEMP/CV_UL_Last_TCP.tmp    
    
    sleep 3
    TimeInSecs=60
    Printer_Check4Idle
    if [ $PrinterCheck4Idle -eq 0 ]; then
        echo "Printer Restart Failed"
        exit 1
    fi
    
    $ITFSEND -d -r*9 -l -m1 -tx -s$IPADDR < "$DATA"
    Errcode=$?
    if [ $Errcode -ne 0 ] && [ $Errcode -ne 250 ]; then
        echo $Errcode
        read
        exit 1
    fi
    
else if (($CHOICE == 2))
then
    if (($LASTCHOICE == 1))
    then
        IPADDR=$(<$TEMP/CV_UL_Last_TCP.tmp)
        
    $ITFSEND -d -r*9 -l -m1 -tx -s$IPADDR < "$FIRMWARE"
    Errcode=$?
    if [ $Errcode -ne 0 ] && [ $Errcode -ne 250 ]; then
        echo $Errcode
        read
        exit 1
    fi
    
    echo $IPADDR > $TEMP/CV_UL_Last_TCP.tmp    
    
    sleep 3
    TimeInSecs=60
    Printer_Check4Idle
    if [ $PrinterCheck4Idle -eq 0 ]; then
        echo "Printer Restart Failed"
        exit 1
    fi
    
    $ITFSEND -d -r*9 -l -m1 -tx -s$IPADDR < "$DATA"
    Errcode=$?
    if [ $Errcode -ne 0 ] && [ $Errcode -ne 250 ]; then
        echo $Errcode
        read
        exit 1
    fi
    fi
fi
fi

sleep 2
