Dim sDefaultIP : sDefaultIP = "192.168.0.21"
Dim sDefaultLPT : sDefaultLPT = "1"
Dim sDefaultCOM : SDefaultCOM = "1"
Dim sDefaultBaudrate : sDefaultBaudrate = "11520"
Dim sDefaultDatabit : sDefaultDatabit = "8"
Dim sDefaultParity : sDefaultParity = "N"
Dim sDefaultStopbit : sDefaultStopbit = "1"

Dim strMsgMain, strMsgCom

Sub GetTempFileContent()
    Dim f
    Set f = fso.GetFile(tempFileName)
    If f.Size > 0 then
        Set f = fso.OpenTextFile(tempFileName, fsoForReading)
        sIPAddress = f.ReadLine
        sLPT = f.ReadLine
        sCOM = f.ReadLine
        sBaudrate = f.ReadLine
    	sDatabit = f.ReadLine
    	sParity	= f.ReadLine
    	sStopbit = f.ReadLine
        f.Close
    Else
        sIPAddress = sDefaultIP
        sLPT = sDefaultLPT
        sCOM = sDefaultCOM
        sBaudrate = sDefaultBaudrate
    	sDatabit = sDefaultDatabit
    	sParity	= sDefaultParity
    	sStopbit = sDefaultStopbit
    End If    
End Sub

Sub SaveTempFileContent()
    Dim f
    Set f = fso.OpenTextFile(tempFileName, fsoForWriting)
    f.WriteLine sIPAddress
    f.WriteLine sLPT
    f.WriteLine sCOM
    f.WriteLine sBaudrate
    f.WriteLine sDatabit
    f.WriteLine sParity
    f.WriteLine sStopbit
    f.Close
End Sub

Sub MenuIP
    Dim strMsg, inp, inploop
    strMsg = "Enter new IP Address" & vbCR
    inploop = True
    Do While inploop
        inp = InputBox(strMsg, sTitle)
        Select Case inp
            Case ""
                inploop = False
            Case Else
                sIPAddress = inp
                SaveTempFileContent()
                inploop = False
        End Select
    Loop
End Sub

Sub MenuLPT
    Dim strMsg, inp, inploop
    strMsg = "Enter new LPT-Port" & vbCR
    inploop = True
    Do While inploop
        inp = InputBox(strMsg, sTitle)
        Select Case inp
            Case ""
                inploop = False
            Case Else
                sLPT = inp
                SaveTempFileContent()
                inploop = False
        End Select
    Loop
End Sub

Sub MenuComPort
	Dim strMsg, inploop, inp
	strMsg = "Enter new COM-Port (0-2)" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sCOM = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub

Sub MenuComBaudrate
	Dim strMsg, inploop, inp
	strMsg = "Enter new Baudrate (1200-115200):" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sBaudrate = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub


Sub MenuComDatabit
	Dim strMsg, inploop, inp
	strMsg = "Enter new Databit (Defaults to 8):" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sDatabit = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub

Sub MenuComParity
	Dim strMsg, inploop, inp
	strMsg = "Enter new Parity (n-e-o)" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sParity = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub

Sub MenuComStopbit
	Dim strMsg, inploop, inp
	strMsg = "Enter new Stopbit (Defaults to 2):" & vbCr
	inploop = True
	Do While inploop
		inp = InputBox(strMsg, sTitle)
		Select Case inp
			Case ""
				inploop = False
			Case Else
				sStopbit = inp
				SaveTempFileContent()
				inploop = False
		End Select
	Loop
End Sub
			

Sub MenuMainStrMsg( bSerial )
    strMsgMain =          "1. Update to Default IP:" & sDefaultIP & vbCR
    strMsgMain = strMsgMain & "2. Update to IP " & sIPAddress & vbCR
    strMsgMain = strMsgMain & "3. Update to LPT" & sLPT & vbCr
    If (bSerial) then
        strMsgMain = strMsgMain & "4. Update to COM" & sCom & " (" & sBaudrate _
                     & "-" & sDatabit & "-" & sParity & "-" & sStopbit & ")" & vbCr
    End If
    strMsgMain = strMsgMain & "5. Change IP-Address" & vbCR
    strMsgMain = strMsgMain & "6. Change LPT-Port" & vbCr
    If (bSerial) then    
        strMsgMain = strMsgMain & "7. Change COM-Setting" & vbCr
    End If
    strMsgMain = strMsgMain & "or directly enter IP-Address" & vbCR
End Sub

Sub MenuComStrMsg()
	strMsgCom = "1. Change Port: " & sCOM & vbCr
	strMsgCom = strMsgCom & "2. Change Baudrate: " & sBaudrate & vbCr
	strMsgCom = strMsgCom & "3. Change Databit: " & sDatabit & vbCr
	strMsgCom = strMsgCom & "4. Change Parity: " & sParity & vbCr
	strMsgCom = strMsgCom & "5. Change Stopbit: " & sStopbit & vbCr 
End Sub	

Sub MenuCom()
	Dim  inploop, inp
	MenuComStrMsg()
	inploop = True
	Do While inploop
		GetTempFileContent()
		inp = InputBox(strMsgCom, "Com Port State")
		Select Case inp
			Case ""				
				inploop = False
			Case "1"
				MenuComPort()
				inploop = False
			Case "2"
				MenuComBaudrate()
				inploop = False
			Case "3"
				MenuComDatabit()
				inploop = False
			Case "4"
				MenuComParity()
				inploop = False
			Case "5"
				MenuComStopbit()
				inploop = False
			Case Else
				MsgBox "Incorrect Selection!" & vbCR & "Enter selection (1-5) "
		End Select
	Loop
End Sub

Function MenuMain()
    Dim inp, inploop
    MenuMainStrMsg(True)
    inploop = True
    Do While inploop
        inp = InputBox(strMsgMain, sTitle)
        Select Case inp
            Case ""
                WScript.Quit(1)
            Case "1"
                sIPAddress = sDefaultIP
                inploop = False
                MenuMain = 0
            Case "2"
                inploop = False
                MenuMain = 0
            Case "3"
                inploop = False
                MenuMain = 1
            Case "4"
            	inploop = False
            	MenuMain = 2            
            Case "5"
                MenuIP()
                MenuMainStrMsg(True)
            Case "6"
                MenuLPT()
                MenuMainStrMsg(True)
            Case "7"
            	MenuCom()
            	MenuMainStrMsg(True)
            Case Else
                If Len(inp) = 1 then
                    MsgBox "Incorrect input!" & vbCR & "Enter selection (i.e. '1') or IP-Address"
                ElseIf Len(inp) < 7 then
                    MsgBox "Incorrect input!" & vbCR & "Enter selection (i.e. '1') or IP-Address"
                Else
                    sIPAddress = inp
                    SaveTempFileContent()
                    inploop = False
                    MenuMain = 0
                End If
        End Select
    Loop
End Function

Function MenuMainWithoutSerial()
    Dim inp, inploop
    MenuMainStrMsg(False)
    inploop = True
    Do While inploop
        inp = InputBox(strMsgMain, sTitle)
        Select Case inp
            Case ""
                WScript.Quit(1)
            Case "1"
                sIPAddress = sDefaultIP
                inploop = False
                MenuMainWithoutSerial = 0
            Case "2"
                inploop = False
                MenuMainWithoutSerial = 0
            Case "3"
                inploop = False
                MenuMainWithoutSerial = 1          
            Case "5"
                MenuIP()
                MenuMainStrMsg()
            Case "6"
                MenuLPT()
                MenuMainStrMsg()
            Case Else
                If Len(inp) = 1 then
                    MsgBox "Incorrect input!" & vbCR & "Enter selection (i.e. '1') or IP-Address"
                ElseIf Len(inp) < 7 then
                    MsgBox "Incorrect input!" & vbCR & "Enter selection (i.e. '1') or IP-Address"
                Else
                    sIPAddress = inp
                    SaveTempFileContent()
                    inploop = False
                    MenuMainWithoutSerial = 0
                End If
        End Select
    Loop
End Function

Sub UpdateLPT( sUpdFile, sLPT )
    Dim objPrintQueueJobs()

    Dim pb
    Dim percentComplete
    Set pb = New ProgressBar
    percentComplete = 0
    pb.SetTitle(sUpdFile)
    pb.SetText("Updating ...")
    pb.Show()

    strComputer = "."
    Set objWMIService = GetObject("winmgmts:" _
        & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")

    Set colPrintQueues =  objWMIService.ExecQuery _
        ("Select * from Win32_PerfFormattedData_Spooler_PrintQueue Where " & _
            "Name <> '_Total'")
    
    objPrintQueueSize = 0
    For Each objPrintQueue in colPrintQueues
        objPrintQueueSize = objPrintQueueSize + 1
    Next
    redim objPrintQueueJobs(objPrintQueueSize)
    i = 0
    For Each objPrintQueue in colPrintQueues
        objPrintQueueJobs(i) = objPrintQueue.Jobs
        i = i + 1
    Next
    
    objShell.Run "cmd /C copy " & sUpdFile & " LPT" & sLPT & ": /B", 1, True
    WScript.Sleep 1000


    Set colPrintQueues =  objWMIService.ExecQuery _
        ("Select * from Win32_PerfFormattedData_Spooler_PrintQueue Where " & _
            "Name <> '_Total'")
    jobs = 0
    i = 0
    For Each objPrintQueue in colPrintQueues
        If NOT objPrintQueue.Jobs = objPrintQueueJobs(i) Then
            strPath = "Rundll32 printui.dll,PrintUIEntry /o /n""" & Replace(objPrintQueue.Name, ",", "/") & """"
            objShell.Run strPath
            jobs = 1
        End If
        i = i + 1
    Next

    Do While jobs = 1
        jobs = 0
        Set colPrintQueues =  objWMIService.ExecQuery _
            ("Select * from Win32_PerfFormattedData_Spooler_PrintQueue Where " & _
                "Name <> '_Total'")
        i = 0
        For Each objPrintQueue in colPrintQueues            
            If NOT objPrintQueue.Jobs = objPrintQueueJobs(i) Then
                jobs = 1
            End If
            i = i + 1
        Next
        pb.Update(percentComplete)
        percentComplete = percentComplete + 1
        ' Sicherung falls was schief geht
        If percentComplete > 300  Then
            jobs = 0
        End If
        WScript.Sleep 1000        
    Loop    
    
    pb.Close()
End Sub

Class ProgressBar
    Private m_PercentComplete
    Private m_CurrentStep    
    Private m_Title
    Private m_Text
    Private m_StatusBarText
    Private m_ProgressBar
 
    'Initialize defaults
    Private Sub ProgessBar_Initialize
        m_PercentComplete = 0
        m_CurrentStep = 0
        m_Title = "Progress"
        m_Text = ""
    End Sub
 
    Public Function SetTitle(pTitle)
        m_Title = pTitle
    End Function
 
    Public Function SetText(pText)
        m_Text = pText
    End Function
 
    Public Function Update(percentComplete)
        m_PercentComplete = percentComplete
        UpdateProgressBar()
    End Function
 
    Public Function Show()
        Set m_ProgressBar = CreateObject("InternetExplorer.Application")
        'in code, the colon acts as a line feed
        m_ProgressBar.navigate2 "about:blank" : m_ProgressBar.width = 315 : m_ProgressBar.height = 40 : m_ProgressBar.toolbar = false : m_ProgressBar.menubar = false : m_ProgressBar.statusbar = false : m_ProgressBar.visible = True
        m_ProgressBar.document.write "<body Scroll=no style='margin:0px;padding:0px;'><div style='text-align:center;'><span name='pc' id='pc'>0</span></div>"
        m_ProgressBar.document.write "<div id='statusbar' name='statusbar' style='border:1px solid blue;line-height:10px;height:10px;color:blue;'></div>"
        m_ProgressBar.document.write "<div style='text-align:center'><span id='text' name='text'></span></div>"        
    End Function
 
    Public Function Close()
        m_ProgressBar.quit
    End Function
 
    Private Function UpdateProgressBar()
        If m_PercentComplete = 0 Then
            m_StatusBarText = ""
        End If
        For n = m_CurrentStep to m_PercentComplete - 1
            m_StatusBarText = m_StatusBarText & "|"
            m_ProgressBar.Document.GetElementById("statusbar").InnerHtml = m_StatusBarText
            m_ProgressBar.Document.title = n & "% Complete : " & m_Title
            m_ProgressBar.Document.GetElementById("pc").InnerHtml = n & "% Complete : " & m_Title
            wscript.sleep 10
        Next
        m_ProgressBar.Document.GetElementById("statusbar").InnerHtml = m_StatusBarText
        m_ProgressBar.Document.title = m_PercentComplete & "% Complete : " & m_Title
        m_ProgressBar.Document.GetElementById("pc").InnerHtml = m_PercentComplete & "% Complete : " & m_Title
        m_ProgressBar.Document.GetElementById("text").InnerHtml = m_Text
        m_CurrentStep = m_PercentComplete
    End Function
End Class