RunDir = WScript.ScriptFullName
RunDir = Left(RunDir,InStr(RunDir,WScript.ScriptName)-2)

Include Rundir & "\tools\common.vbs"

Sub Include( cNameScript )
    Set oFS = CreateObject("Scripting.FileSystemObject")		
    Set oFile = oFS.OpenTextFile( cNameScript )
    ExecuteGlobal oFile.ReadAll()
    oFile.Close
End Sub

Dim sFirmware : sFirmware = "firmware.prn"
Dim sData : sData = "data.prn"
Dim sSpecial : sSpecial = "special.prn"
Dim sTitle :sTitle = "Printer Firmware Update"

Dim sIPAddress
Dim sLPT
Dim sCOM
Dim sBaudrate
Dim sDatabit
Dim sParity
Dim sStopbit

Dim wshShell, fso, tempDir, tempFileName, fTemp
Const fsoForReading = 1, fsoForWriting = 2

Dim objShell

Dim iChoice

Dim pBar
Dim pComplete

Function GetDate()
    GetDate = DateDiff("s", "01/01/1970 00:00:00", Now())
End Function

Function Printer_Check4Idle(TimeInSecs)
    Dim START_T, CHECK, PRT_STATUS, ERG, ErrCode
    Dim f
	dim fSize
    
    START_T=GetDate
    CHECK=1
    Do While CHECK = 1
	
	    ret = objShell.Run("cmd /C tools\printf \x01U\x17 | %TEMP%\itfsend -d -s" & sIPAddress & " -p9099 -rt2 -l -m0 -o" & tempDir & "\itfsend.log", 1, True)
        Set f = fso.GetFile(tempDir & "\itfsend.log")
		fSize = f.Size
        If f.Size > 0 then
            Set f = fso.OpenTextFile(tempDir & "\itfsend.log", fsoForReading)
            PRT_STATUS = f.ReadAll            
            f.Close
        End If
		
        PRT_STATUS=Mid(PRT_STATUS, 2, 11)
		'Wscript.Echo "PrtStat: " & PRT_STATUS
        If StrComp(PRT_STATUS,"1.0;BOOT-SW") = 0 Or fSize = 0 Then
		    'Wscript.Echo "Failed"
            ErrCode=1
			iRetVal = objShell.Popup("Try to connect, please wait ...", 1, "Printer_Check4Idle", vbOKCancel+vbSystemModal)
        Else
		
		    'Wscript.Echo "Not U-Boot! Try Status Req"			
			ret = objShell.Run("cmd /C tools\printf \x01SE\x17 | %TEMP%\itfsend -d -s" & sIPAddress & " -p9099 -rt2 -l -m0 -o" & tempDir & "\itfsend.log", 1, True)
			Set f = fso.GetFile(tempDir & "\itfsend.log")
			If f.Size > 0 then
				Set f = fso.OpenTextFile(tempDir & "\itfsend.log", fsoForReading)
				PRT_STATUS = f.ReadAll            
				f.Close
			End If
			PRT_STATUS=Mid(PRT_STATUS, 2, 5)
			If StrComp(PRT_STATUS,"#Idle") = 0 Or StrComp(PRT_STATUS,"#Erro") = 0 Or StrComp(PRT_STATUS,"#Stop") = 0 Then
				'Wscript.Echo "Success"
				ErrCode=0
			Else
				'Wscript.Echo "Failed"
				ErrCode=1
				iRetVal = objShell.Popup("Try to connect, please wait ...", 1, "Printer_Check4Idle", vbOKCancel+vbSystemModal)
			End If
			
        End If
		
        If Not ErrCode = 0 Then
            ERG=GetDate-START_T
            If ERG > TimeInSecs Then
                CHECK=0
            End If
        Else
            CHECK=0
        End If
		If iRetVal = vbCancel Then
			CHECK=0
		End If
    Loop
    
    If ErrCode = 0 Then
        Printer_Check4Idle = True
    Else
        Printer_Check4Idle = False
    End If
End Function

Set wshShell = CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")
tempDir = wshShell.ExpandEnvironmentStrings("%TEMP%") 
tempFileName = tempDir & "\PrinterUpdate2.ini"
If Not fso.FileExists(tempFileName) Then
    Set fTemp = fso.CreateTextFile(tempFileName, False)
    fTemp.close
End If

Set objShell = CreateObject("WScript.Shell")

' Liest sIPAddress und sLPT
GetTempFileContent

' itfsend nach temp kopieren wegen evtl. Probleme beim Ausfhren von Netzlaufwerken (Rechte und so)
objShell.Run "cmd /C copy /Y tools\itfsend.exe %TEMP%"
objShell.Run "cmd /C copy /Y tools\iconv.dll %TEMP%"
objShell.Run "cmd /C copy /Y tools\intl.dll %TEMP%"

' To use Wscript.Echo call cscript Update.vbs from Command-Line
'Wscript.Echo "Update.vbs"

' Main Menue
iChoice = MenuMain()

' Update Firmware & Data
If iChoice = 0 Then
    objShell.Run "cmd /C %TEMP%\itfsend -d -r*9 -l -m1 -tx -s" & sIPAddress & " -i" & sFirmware, 1, True
    
    Wscript.Sleep 3*1000
    If Not Printer_Check4Idle(60) Then
        MsgBox "Printer Restart Failed", 0, "Error" 
        WScript.Quit(0)
    End If
    objShell.Run "cmd /C %TEMP%\itfsend -d -r*9 -l -m1 -tx -s" & sIPAddress & " -i" & sData, 1, True
    
    If fso.FileExists(sSpecial) Then
        Wscript.Sleep 1*1000
        If Not Printer_Check4Idle(60) Then
            MsgBox "Printer Restart Failed", 0, "Error" 
            WScript.Quit(0)
        End If
        objShell.Run "cmd /C %TEMP%\itfsend -d -r*9 -l -m1 -tx -s" & sIPAddress & " -i" & sSpecial, 1, True
    End If
    
ElseIf iChoice = 1 Then
    Set pBar = New ProgressBar    
    pBar.SetTitle(sFirmware)
    pBar.SetText("Waiting ...")    
    
    UpdateLPT sFirmware, sLPT
    
    pBar.Show()
    pComplete = 0
    Do While pComplete < 100
        pBar.Update(pComplete)
        pComplete = pComplete + 2
        Wscript.Sleep 1*1000
    Loop
    pBar.Close()
    
    UpdateLPT sData, sLPT
    
    If fso.FileExists(sSpecial) Then
        pBar.Show()
        pComplete = 0
        Do While pComplete < 100
            pBar.Update(pComplete)
            pComplete = pComplete + 2
            Wscript.Sleep 1*1000
        Loop
        pBar.Close()
        
        UpdateLPT sSpecial, sLPT
    End If
Else
    Set pBar = New ProgressBar    
    pBar.SetTitle(sFirmware)
    pBar.SetText("Waiting ...")   
    
    objShell.Run "cmd /C %TEMP%\itfsend.exe -d -r30 -l -m1 -tx -c" & sCOM & " -b" & sBaudrate & " -d" & _ 
            sDatabit & " -s" & sStopbit & " -p" & sParity & " -i" & sFirmware, 1, True
            
    pBar.Show()
    pComplete = 0
    Do While pComplete < 100
        pBar.Update(pComplete)
        pComplete = pComplete + 2
        Wscript.Sleep 1*1000
    Loop
    pBar.Close()
    
    objShell.Run "cmd /C %TEMP%\itfsend.exe -d -r30 -l -m1 -tx -c" & sCOM & " -b" & sBaudrate & " -d" & _ 
            sDatabit & " -s" & sStopbit & " -p" & sParity & " -i" & sData, 1, True
            
    If fso.FileExists(sSpecial) Then
        pBar.Show()
        pComplete = 0
        Do While pComplete < 100
            pBar.Update(pComplete)
            pComplete = pComplete + 2
            Wscript.Sleep 1*1000
        Loop
        pBar.Close()
        
        objShell.Run "cmd /C %TEMP%\itfsend.exe -d -r30 -l -m1 -tx -c" & sCOM & " -b" & sBaudrate & " -d" & _ 
                sDatabit & " -s" & sStopbit & " -p" & sParity & " -i" & sSpecial, 1, True    
        End If
End If

WScript.Quit(0)
